require "TimedActions/ISBaseTimedAction"

TABAS_ReAttachHotbar = ISBaseTimedAction:derive("TABAS_ReAttachHotbar")

function TABAS_ReAttachHotbar:isValid()
	return true
end

function TABAS_ReAttachHotbar:perform()
    if self.attachedItems then  --- self.attachedItems = {item, slot, slotIndex}
        local hotbar = getPlayerHotbar(self.character:getPlayerNum())
        if hotbar then
            local doAnim = true
            for i, attachedItem in pairs(self.attachedItems) do
                local item = attachedItem.item
                local slotDef = attachedItem.slot.def
                -- local slotType = hotbar:getSlotDef(tostring(slotDef.type))
                if hotbar:haveThisSlot(slotDef.type) and hotbar:canBeAttached(attachedItem.slot, item) then
                --- ISHotbar:attachItem (item, slot, slotIndex, slotDef, doAnim)
                    hotbar:attachItem(item, slotDef.attachments[item:getAttachmentType()], attachedItem.slotIndex, slotDef, doAnim)
                    doAnim = false
                end
            end
        end
    end
	ISBaseTimedAction.perform(self)
end

function TABAS_ReAttachHotbar:new(character, attachedItems)
	local o = {}
	setmetatable(o, self)
	self.__index = self
    o.character = character
    o.attachedItems = attachedItems
	o.maxTime = 0
	-- o.activated = activated
	return o
end